Rem
Rem $Header: georaster_demo.sql 10-aug-2004.08:57:03 wexu Exp $
Rem
Rem georaster_demo.sql
Rem
Rem Copyright (c) 2002, 2004, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      georaster_demo.sql
Rem
Rem    DESCRIPTION
Rem      Some samples on how to use Oracle GeoRaster
Rem
Rem    NOTES
Rem      The data and tasks in these examples are selected primarily
Rem      for their tutorial value, and are not intended as "realistic" 
Rem      in the context of a production application. 
Rem 
Rem      Some scripts might fail if a RDT name is already used by another 
Rem      user. In those cases, either rename the existing RDT or
Rem      modify the demo scripts to avoid the conflicts.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    wexu        08/10/04 - uncomment the compress demo 
Rem    wexu        08/05/04 - connect as scott 
Rem    qxie        09/24/03 - comments 
Rem    qxie        07/22/03 - comments
Rem    qxie        03/27/03 - add drop georaster table notes
Rem    qxie        10/31/02 - qxie_demo1
Rem    qxie        10/30/02 - add demos
Rem    qxie        10/24/02 - Created
Rem

-------------------------------------------------------------------
-- create a georaster table and setup its ddl and dml triggers
-------------------------------------------------------------------
@create_georaster_table.sql


-------------------------------------------------------------------
-- import external images into GeoRaster objects
-------------------------------------------------------------------
@import_georaster.sql


-------------------------------------------------------------------
-- generate sample georaster objects for demo purposes
-------------------------------------------------------------------
@generate_georaster.sql


-------------------------------------------------------------------
-- validate georaster objects
-------------------------------------------------------------------
@validate_georaster.sql


-------------------------------------------------------------------
-- query on georaster objects
-------------------------------------------------------------------
@query_georaster.sql


-------------------------------------------------------------------
-- copy and change storage formats of georaster objects
-------------------------------------------------------------------
@ccf_georaster.sql


-------------------------------------------------------------------
-- subset and/or crop georaster objects
-------------------------------------------------------------------
@subset_georaster.sql


-------------------------------------------------------------------
-- scale (enlarge or shrink) georaster objects
-------------------------------------------------------------------
@scale_georaster.sql


-------------------------------------------------------------------
-- generate pyramids of georaster object
-------------------------------------------------------------------
@pyramid_georaster.sql


-------------------------------------------------------------------
-- compression/decompression
-------------------------------------------------------------------
@compress_georaster.sql


-------------------------------------------------------------------
-- drop georaster table and RDT tables
-- Not invoked in this script. You can manually run it if you 
-- don't want the results any more.
-------------------------------------------------------------------
--@drop_georaster_table.sql




